<?php

/**
 * Configuration settings for BotBlocker.Pro and Google reCAPTCHA v3 integration.
 * 
 * @var array $config Configuration options for the API and reCAPTCHA services.
 * 
 * - 'apiKey': (Required) Your BotBlocker.Pro API Key. Get it from https://botblocker.pro/developer.
 * - 'siteKey': (Optional) Your Google reCAPTCHA v3 Site Key. Create one at https://www.google.com/recaptcha/admin/create.
 * - 'secretKey': (Optional) Your Google reCAPTCHA v3 Secret Key. Create one at https://www.google.com/recaptcha/admin/create.
 */
$config = [
    'apiKey' => 'API_KEY',        // Required: BotBlocker.Pro API Key (https://botblocker.pro/developer)
    'siteKey' => 'SITE_KEY',      // Optional: Google reCAPTCHA v3 Site Key (https://www.google.com/recaptcha/admin/create)
    'secretKey' => 'SECRET_KEY',  // Optional: Google reCAPTCHA v3 Secret Key (https://www.google.com/recaptcha/admin/create)
];
